/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverest;

import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class DataRepUnRegister
extends Thread {
    private static final String TRACE_MASKT = "XSRDDRAT";
    private static final String TRACE_MASKF = "XSRDDRAF";
    private static final String TRACE_MASKD = "XSRDDRAD";
    private String machineId;
    private String[] ipAddr;
    FcsServiceId id;

    DataRepUnRegister(String machineId, String[] ipAddr, FcsServiceId id) {
        this.machineId = machineId;
        this.ipAddr = ipAddr;
        this.id = id;
    }

    public void run() {
        DataRepApp dataRepApp = DataRepApp.getDataRepApp();
        FcsServer server = FcsServer.getFcsServer();
        MachineId myMachine = server.getLocalMachineId();
        for (int j = 0; j < this.ipAddr.length; ++j) {
            Trace.trace(TRACE_MASKT, "DataRepUnRegister(" + this.machineId + " with " + this.ipAddr[j] + ")");
            try {
                MachineId mach = new MachineId("Dummy", "", 1.0, 1, 1, new InetAddress[]{InetAddress.getByName(this.ipAddr[j])}, new boolean[]{false});
                FcsConnection connection = FcsConnection.connect(mach, this.id);
                Socket s = connection.getSocket();
                ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(s.getInputStream()));
                ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(s.getOutputStream()));
                Object[] myObjIn = (Object[])in.readObject();
                String inString = (String)myObjIn[0];
                Trace.trace(TRACE_MASKT, "DataRepUnRegister.received:" + inString);
                MachineId theirMachine = (MachineId)myObjIn[1];
                if (!this.machineId.equals(theirMachine.getName())) {
                    Trace.trace(TRACE_MASKT, "DataRepUnRegister.received MachineId: " + theirMachine.getName() + " expected: " + this.machineId);
                    continue;
                }
                Trace.trace(TRACE_MASKT, "DataRepUnRegister.received Machine:" + theirMachine);
                out.writeObject("UnRegister Me");
                out.writeObject(myMachine);
                out.flush();
                inString = (String)in.readObject();
                Trace.trace(TRACE_MASKT, "DataRepUnRegister.received:" + inString);
                if (!inString.equals("Id Deleted")) continue;
                out.writeObject("Exit");
                out.flush();
                s.close();
                break;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "DataRepUnRegister.exception " + e);
                Trace.trace(TRACE_MASKT, e);
            }
        }
    }
}

